/*
 Erica Sadun, http://ericasadun.com
 iPhone Developer's Cookbook, 5.x Edition
 BSD License, Use at your own risk
 */

#import <UIKit/UIKit.h>
#import <MediaPlayer/MediaPlayer.h>

#define COOKBOOK_PURPLE_COLOR [UIColor colorWithRed:0.20392f green:0.19607f blue:0.61176f alpha:1.0f]
#define BARBUTTON(TITLE, SELECTOR) [[UIBarButtonItem alloc] initWithTitle:TITLE style:UIBarButtonItemStylePlain target:self action:SELECTOR]
#define IS_IPAD	(UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad)

// Duży film (35 MB).
#define LARGE_URL @"http://www.archive.org/download/BettyBoopCartoons/Betty_Boop_More_Pep_1936_512kb.mp4"

// Mały film (3 MB).
#define SMALL_URL @"http://www.archive.org/download/Drive-inSaveFreeTv/Drive-in--SaveFreeTv_512kb.mp4"

// Nieprawidłowy adres filmu.
#define FAKE_URL @"http://www.idontbelievethisisavalidurlforthisexample.com"

#define DEST_PATH	[NSHomeDirectory() stringByAppendingString:@"/Documents/Movie.mp4"]

@interface TestBedViewController : UIViewController
{
    UITextView *textView;
    NSMutableString *log;
    BOOL success;

    UISegmentedControl *seg;
    MPMoviePlayerController *movieController;
}
- (void) log: (NSString *) formatstring, ...;
@end

@implementation TestBedViewController
#pragma mark -
-(void)myMovieFinishedCallback:(NSNotification*)aNotification
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [movieController.view removeFromSuperview];
    movieController = nil;
}

- (void) downloadFinished
{
    // Restore GUI
    self.navigationItem.rightBarButtonItem = BARBUTTON(@"Idź", @selector(go));
    seg.enabled = YES;
    [UIApplication sharedApplication].networkActivityIndicatorVisible = NO;

    if (!success)
    {
        [self log:@"Pobieranie zakończyło się niepowodzeniem."];
        return;
    }   
    
    // Przygotowanie odtwarzacza.
    movieController = [[MPMoviePlayerController alloc] initWithContentURL:[NSURL fileURLWithPath:DEST_PATH]];
	movieController.view.frame = self.view.bounds;
    movieController.controlStyle = MPMovieControlStyleFullscreen;
	[self.view addSubview:movieController.view];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(myMovieFinishedCallback:) name:MPMoviePlayerPlaybackDidFinishNotification object:movieController];

    [movieController play];
}

- (void) getData: (NSURL *) url
{
	[self log:@"Przygotowanie odtwarzacza."];
    
    NSDate *startDate = [NSDate date];

	NSMutableURLRequest *theRequest = [NSMutableURLRequest requestWithURL:url];
	NSURLResponse *response;
	NSError *error;
    success = NO;
    
	NSData* result = [NSURLConnection sendSynchronousRequest:theRequest returningResponse:&response error:&error];
        
    if (!result)
    {
		[self log:@"Błąd podczas pobierania: %@", [error localizedFailureReason]];
        return;
    }
    
    if ((response.expectedContentLength == NSURLResponseUnknownLength) ||
        (response.expectedContentLength < 0))
    {
		[self log:@"Błąd podczas pobierania."];
        return;
    }
    
    if (![response.suggestedFilename isEqualToString:url.path.lastPathComponent])
    {
        [self log:@"Nazwy plików nie pasują do siebie. To jest prawdopodobnie strona błędu przygotowana przez dostawcę"];
        return;
    }

    if (response.expectedContentLength != result.length)
    {
        [self log:@"Otrzymano %d bajtów, oczekiwano %d", result.length, response.expectedContentLength];
        return;
    }

    success = YES;
    [self log:@"Odczytano %d bajtów", result.length];
    [result writeToFile:DEST_PATH atomically:YES];
    [self log:@"Dane zostały zapisane w pliku: %@.", DEST_PATH];
    [self log:@"Sugerowana nazwa pliku odpowiedzi: %@", response.suggestedFilename];
    [self log:@"Czas wykonywania operacji: %0.2f sekund.", [[NSDate date] timeIntervalSinceDate:startDate]];
}

- (void) go
{
    self.navigationItem.rightBarButtonItem = nil;
    seg.enabled = NO;
    
    NSArray *items = [NSArray arrayWithObjects: SMALL_URL, LARGE_URL, FAKE_URL, nil];
    NSString *whichItem = [items objectAtIndex:seg.selectedSegmentIndex];
    NSURL *sourceURL = [NSURL URLWithString:whichItem];

    // Usunięcie wszelkich istniejących danych.
    if ([[NSFileManager defaultManager] fileExistsAtPath:DEST_PATH])
        [[NSFileManager defaultManager] removeItemAtPath:DEST_PATH error:nil];
    
    [UIApplication sharedApplication].networkActivityIndicatorVisible = YES;
    [[[NSOperationQueue alloc] init] addOperationWithBlock:
     ^{
         [self getData:sourceURL];
         [[NSOperationQueue mainQueue] addOperationWithBlock:^{
             // Zakończenie w wątku głównym.
             [self downloadFinished];
         }];
     }];
}

#pragma mark -

#pragma mark Konfiguracja
- (void) loadView
{
    [super loadView];
    self.view.backgroundColor = [UIColor whiteColor];
    textView = [[UITextView alloc] initWithFrame:CGRectZero];
    textView.editable = NO;
    textView.font = [UIFont fontWithName:@"Futura" size:IS_IPAD ? 24.0f : 12.0f];
    textView.textColor = COOKBOOK_PURPLE_COLOR;
    [self.view addSubview:textView];
    
    log = [NSMutableString string];
    self.navigationItem.rightBarButtonItem = BARBUTTON(@"Idź", @selector(go));
    
    // Użytkownik może wybrać dane.
    NSArray *items = [@"Krótki Długi Nieprawidłowy" componentsSeparatedByString:@" "];
	seg = [[UISegmentedControl alloc] initWithItems:items];
	seg.selectedSegmentIndex = 0;
	seg.segmentedControlStyle = UISegmentedControlStyleBar;
	self.navigationItem.titleView = seg;
}

- (void) log: (NSString *) formatstring, ...
{
	if (!formatstring) return;
    
	va_list arglist;
	va_start(arglist, formatstring);
	NSString *outstring = [[NSString alloc] initWithFormat:formatstring arguments:arglist];
	va_end(arglist);
    
    printf("%s\n", [outstring UTF8String]);
    
    if (!log) log = [NSMutableString string];
    [log appendString:@"\n"];
    [log appendString:outstring];

    // Uaktualnienie GUI w wątku głównym.
    [[NSOperationQueue mainQueue] addOperationWithBlock:^(){
        textView.text = log;
    }];
}

- (void) viewDidAppear:(BOOL)animated
{
    textView.frame = self.view.bounds;
    movieController.view.frame = self.view.bounds;
}

- (void) viewDidLayoutSubviews
{
    [self viewDidAppear:NO];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return YES;
}
@end

#pragma mark -

#pragma mark Konfiguracja aplikacji
@interface TestBedAppDelegate : NSObject <UIApplicationDelegate>
{
	UIWindow *window;
}
@end
@implementation TestBedAppDelegate
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions 
{	
    [[UINavigationBar appearance] setTintColor:COOKBOOK_PURPLE_COLOR];
    
	window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
	TestBedViewController *tbvc = [[TestBedViewController alloc] init];
    UINavigationController *nav = [[UINavigationController alloc] initWithRootViewController:tbvc];
    window.rootViewController = nav;
	[window makeKeyAndVisible];
    return YES;
}
@end
int main(int argc, char *argv[]) {
    @autoreleasepool {
        int retVal = UIApplicationMain(argc, argv, nil, @"TestBedAppDelegate");
        return retVal;
    }
}